#for printing AUC results into tables used in MS

library(ggplot2)
library(reshape)
library(ggthemes)
library(scales)
library(dplyr)
library(Hmisc)
library(xtable)

load("Output/AUCresult - checkerboard - thinned.RData")
load("Output/AUCresult - lat thinned.RData")

#================overall external AUC comparison for checkerboard===================#
#we subset to only external data
AUC.checkerboard.thinned.ex <- AUC.checkerboard.thinned %>% dplyr::filter(Eval == "external")
AUC.checkerboard.thinned.ex.mean <- aggregate(AUC ~ Model + speciesName, data = AUC.checkerboard.thinned.ex, FUN= "mean" )


#do some wilcox and mean diff
table2 <- matrix(nrow = 14, ncol = 14)


for (i in 1:14){
    for (j in 1:14){
        if (j < i){
            table2[i,j] <- wilcox.test(AUC.checkerboard.thinned.ex.mean[which(AUC.checkerboard.thinned.ex.mean$Model == levels(AUC.checkerboard.thinned.ex.mean$Model)[i]),3],
                                       AUC.checkerboard.thinned.ex.mean[which(AUC.checkerboard.thinned.ex.mean$Model == levels(AUC.checkerboard.thinned.ex.mean$Model)[j]),3],
                                       paired = T)$p.value            
        }else{
            table2[i,j] <- mean(AUC.checkerboard.thinned.ex.mean[which(AUC.checkerboard.thinned.ex.mean$Model == levels(AUC.checkerboard.thinned.ex.mean$Model)[i]),3] - 
                                    AUC.checkerboard.thinned.ex.mean[which(AUC.checkerboard.thinned.ex.mean$Model == levels(AUC.checkerboard.thinned.ex.mean$Model)[j]),3])   
        }
        table2[i,i] <- NA
        
    }
}

colnames(table2) <- as.character(levels(AUC.checkerboard.thinned.ex$Model))
rownames(table2) <- as.character(levels(AUC.checkerboard.thinned.ex$Model))


#print it
xtable(table2, digits = 2)


#=================================best CV models and consistency with best external models====================================
#subset to just individual models
AUC.checkerboard.thinned.ind <- AUC.checkerboard.thinned %>% filter(Model %in% levels(AUC.checkerboard.thinned$Model)[1:8])
#average across folds
AUC.checkerboard.thinned.ind.mean <- aggregate(AUC ~ Model + speciesName + Eval, data = AUC.checkerboard.thinned.ind, FUN= "mean" )
#get best model
AUC.checkerboard.thinned.ind.best <- AUC.checkerboard.thinned.ind.mean %>% group_by(speciesName, Eval) %>% top_n(1, AUC)
AUC.checkerboard.thinned.ind.best.external <- AUC.checkerboard.thinned.ind.best %>% filter(Eval == "external")
AUC.checkerboard.thinned.ind.best.random <- AUC.checkerboard.thinned.ind.best %>% filter(Eval == "random")
for (i in 1:14){
    AUC.checkerboard.thinned.ind.best.random$externalAUC[i] <- AUC.checkerboard.thinned.ex.mean[which(AUC.checkerboard.thinned.ex.mean$speciesName == AUC.checkerboard.thinned.ind.best.random$speciesName[i] & AUC.checkerboard.thinned.ex.mean$Model == AUC.checkerboard.thinned.ind.best.random$Model[i]),"AUC"]
}

AUC.checkerboard.thinned.ind.best.block <- AUC.checkerboard.thinned.ind.best %>% filter(Eval == "block")
for (i in 1:14){
    AUC.checkerboard.thinned.ind.best.block$externalAUC[i] <- AUC.checkerboard.thinned.ex.mean[which(AUC.checkerboard.thinned.ex.mean$speciesName == AUC.checkerboard.thinned.ind.best.block$speciesName[i] & AUC.checkerboard.thinned.ex.mean$Model == AUC.checkerboard.thinned.ind.best.block$Model[i]),"AUC"]
}



table3 <- cbind.data.frame(as.character(AUC.checkerboard.thinned.ind.best.external$speciesName), 
                           as.character(AUC.checkerboard.thinned.ind.best.random$Model), 
                           AUC.checkerboard.thinned.ind.best.external$AUC - AUC.checkerboard.thinned.ind.best.random$externalAUC,
                           as.character(AUC.checkerboard.thinned.ind.best.block$Model),
                           AUC.checkerboard.thinned.ind.best.external$AUC - AUC.checkerboard.thinned.ind.best.block$externalAUC,
                           as.character(AUC.checkerboard.thinned.ind.best.external$Model), 
                           AUC.checkerboard.thinned.ind.best.external$AUC)
colnames(table3) <- c("Species", "Random", "AUC loss", "Block", "AUC loss", "External best", "Best external AUC")

#print it
xtable(table3, digits = 2)

#==============================do the same for lat====================================

#================overall external AUC comparison for lat===================#
#we subset to only external data
AUC.lat.thinned.ex <- AUC.lat.thinned %>% dplyr::filter(Eval == "external")
AUC.lat.thinned.ex.mean <- aggregate(AUC ~ Model + speciesName, data = AUC.lat.thinned.ex, FUN= "mean" )


table4 <- matrix(nrow = 14, ncol = 14)


for (i in 1:14){
    for (j in 1:14){
        if (j < i){
            table4[i,j] <- as.character(sum(AUC.lat.thinned.ex.mean[which(AUC.lat.thinned.ex.mean$Model == levels(AUC.lat.thinned.ex.mean$Model)[i]),3] >= 
                                                AUC.lat.thinned.ex.mean[which(AUC.lat.thinned.ex.mean$Model == levels(AUC.lat.thinned.ex.mean$Model)[j]),3]))           
        }else{
            table4[i,j] <- sprintf("%.2f", round(round(mean(AUC.lat.thinned.ex.mean[which(AUC.lat.thinned.ex.mean$Model == levels(AUC.lat.thinned.ex.mean$Model)[i]),3] - 
                                                                AUC.lat.thinned.ex.mean[which(AUC.lat.thinned.ex.mean$Model == levels(AUC.lat.thinned.ex.mean$Model)[j]),3]),2),2))
        }
        table4[i,i] <- NA
        
    }
}

colnames(table4) <- as.character(levels(AUC.lat.thinned.ex$Model))
rownames(table4) <- as.character(levels(AUC.lat.thinned.ex$Model))


#print it
xtable(table4, digits = 2)


#=================================best CV models and consistency with best external models====================================
#subset to just individual models
AUC.lat.thinned.ind <- AUC.lat.thinned %>% filter(Model %in% levels(AUC.lat.thinned$Model)[1:8])
#average across folds
AUC.lat.thinned.ind.mean <- aggregate(AUC ~ Model + speciesName + Eval, data = AUC.lat.thinned.ind, FUN= "mean" )
#get best model
AUC.lat.thinned.ind.best <- AUC.lat.thinned.ind.mean %>% group_by(speciesName, Eval) %>% top_n(1, AUC)
AUC.lat.thinned.ind.best.external <- AUC.lat.thinned.ind.best %>% filter(Eval == "external")
AUC.lat.thinned.ind.best.random <- AUC.lat.thinned.ind.best %>% filter(Eval == "random")
for (i in 1:4){
    AUC.lat.thinned.ind.best.random$externalAUC[i] <- AUC.lat.thinned.ex.mean[which(AUC.lat.thinned.ex.mean$speciesName == AUC.lat.thinned.ind.best.random$speciesName[i] & AUC.lat.thinned.ex.mean$Model == AUC.lat.thinned.ind.best.random$Model[i]),"AUC"]
}

AUC.lat.thinned.ind.best.block <- AUC.lat.thinned.ind.best %>% filter(Eval == "block")
for (i in 1:4){
    AUC.lat.thinned.ind.best.block$externalAUC[i] <- AUC.lat.thinned.ex.mean[which(AUC.lat.thinned.ex.mean$speciesName == AUC.lat.thinned.ind.best.block$speciesName[i] & AUC.lat.thinned.ex.mean$Model == AUC.lat.thinned.ind.best.block$Model[i]),"AUC"]
}



table5 <- cbind.data.frame(as.character(AUC.lat.thinned.ind.best.external$speciesName), 
                           as.character(AUC.lat.thinned.ind.best.random$Model), 
                           AUC.lat.thinned.ind.best.external$AUC - AUC.lat.thinned.ind.best.random$externalAUC,
                           as.character(AUC.lat.thinned.ind.best.block$Model),
                           AUC.lat.thinned.ind.best.external$AUC - AUC.lat.thinned.ind.best.block$externalAUC,
                           as.character(AUC.lat.thinned.ind.best.external$Model), 
                           AUC.lat.thinned.ind.best.external$AUC)
colnames(table5) <- c("Species", "Random", "AUC loss", "Block", "AUC loss", "External best", "Best external AUC")

#print it
xtable(table5, digits = 2)
